<?php
/**
 * Plugin Name: Raptor Toolkit
 * Author: boxChilli
 * Author URI: https://www.boxchilli.com
 * Description: A toolkit packed with powerful features such as Flexi v4, Forms v2 and much more.
 * Version: 1.5.4
 * Requires PHP: 7.4
 * Tested up to: 6.3.2
 * Requires Plugins: advanced-custom-fields-pro
 */

define( 'RAPTOR_PLUGIN_FILE', __FILE__ );
define( 'RAPTOR_INC', plugin_dir_path( __FILE__ ) . 'includes' );
define( 'RAPTOR_ACF', plugin_dir_path( __FILE__ ) . 'includes/acf/' );


class Raptor_Main {
    function __construct() {
        $this->includes();
    }

    
    function includes() {
        $plugin_path = plugin_dir_path( __FILE__ );

        $plugin_path_includes = $plugin_path . 'includes/';


        require_once $plugin_path_includes . 'raptor-utility-functions.php';
        require_once $plugin_path_includes . 'admin/raptor-install.php';
        require_once $plugin_path_includes . 'activate.php';
        
        require_once $plugin_path_includes . 'class-raptor.php';
        
        require_once $plugin_path_includes . 'raptor-utility-functions.php';
        require_once $plugin_path_includes . 'raptor-template-functions.php';
        require_once $plugin_path_includes . 'raptor-conditional-functions.php';
        
        require_once $plugin_path_includes . 'class-raptor-custom-post-type.php';
        require_once $plugin_path_includes . 'class-raptor-bg-lazy-loading.php';
        require_once $plugin_path_includes . 'raptor-contact-link.php';
        require_once $plugin_path_includes . 'class-api.php';
        require_once $plugin_path_includes . 'class-mail-monitor.php';

        /**
         * Load the Raptor Site Template Install file
         */
        $site_template_install_file = '/var/www/raptor/create/lib/install-site-template.php';

        if ( file_exists( $site_template_install_file ) ) {
            require_once $site_template_install_file;
        }

        if ( raptor()->module_enabled( 'forms' ) ) {
            require_once( $plugin_path_includes . 'forms/forms.php' );
        }

        require_once $plugin_path_includes . 'class-raptor-dynamic-scripts.php';
        require_once $plugin_path_includes . 'class-raptor-selective-image-crop.php';
        require_once $plugin_path_includes . 'acf/acf.php';

        if ( raptor()->module_enabled( 'headless' ) ) {
            require_once $plugin_path_includes . 'headless/graphql-register-fields.php';
            require_once $plugin_path_includes . 'headless/graphql-persisted-queries.php';
            require_once $plugin_path_includes . 'headless/redirects.php';
            require_once $plugin_path_includes . 'headless/nextjs.php';
            require_once $plugin_path_includes . 'headless/headless.php';
        }

        require_once $plugin_path_includes . 'update.php';
        require_once $plugin_path_includes . 'cli.php';
        require_once $plugin_path_includes . 'fleximod.php';
        require_once $plugin_path_includes . 'mod.php';
        require_once $plugin_path_includes . 'cache-manager.php';
        require_once $plugin_path_includes . 'schema.php';

        /**
         * Files moved from functions/
         */
        require_once $plugin_path_includes . 'admin.php';
        require_once $plugin_path_includes . 'editor.php';
        require_once $plugin_path_includes . 'gutenberg.php';
        require_once $plugin_path_includes . 'theme-support.php';
        require_once $plugin_path_includes . 'preload.php';
        require_once $plugin_path_includes . 'security.php';
        require_once $plugin_path_includes . 'fonts.php';
        require_once $plugin_path_includes . 'components.php';

        if ( raptor()->module_enabled( 'forms' ) ) {
            require_once( $plugin_path_includes . 'forms/class-mailchimp-api.php' );
        }
    }
}

new Raptor_Main();
