<?php
/**
 * Theme support
 */


/**  
 *  The fundamental theme support 
 *
 *  @since 1.0
 */
function raptor_theme_support() {
    add_theme_support( 'title-tag' );
    add_theme_support( 'post-thumbnails' );
    add_theme_support( 'custom-logo' );

    if ( function_exists( 'is_woocommerce' ) ) {
        add_theme_support( 'woocommerce' );
    }
}
add_action( 'after_setup_theme', 'raptor_theme_support' );


/**  
 *  Filter and remove <p> tags surrounding images in content
 *
 *  @since 1.0
 */
function raptor_filter_the_content( $content ) {
    // Remove <p> tags wrapped around <img>
    $content = preg_replace( '/<p>\s*(<a .*>)?\s*(<img .* \/>)\s*(<\/a>)?\s*<\/p>/iU', '\1\2\3', $content );

    // Remove p tag surrounding anchor buttons
    $content = preg_replace_callback(
        '/(?:(?:<p[^>]*>\s*)?(<a[^>]+class="[^"]*\bbutton\b[^"]*"[^>]*>.*?<\/a>)(?:\s*<\/p>)?\s*){1,}/is',
        function( $matches ) {
            preg_match_all( '/<a[^>]+class="[^"]*\bbutton\b[^"]*"[^>]*>.*?<\/a>/is', $matches[0], $anchors );
            $buttons = implode( "\n", $anchors[0] );
            return '<div class="button-group">' . $buttons . '</div>';
        },
        $content
    );

    return $content;
}
add_filter( 'the_content', 'raptor_filter_the_content', 100 );
add_filter( 'acf_the_content', 'raptor_filter_the_content', 100 );


// Remove [...] from end of returned excerpt
add_filter( 'excerpt_more', '__return_empty_string' );
