<?php
/**
 * Raptor Conditional Functions
 */

defined( 'ABSPATH' ) || exit;

/**  
 *  Check if AJAX call is doing form submission
 *
 *  @since 1.0
 *  @return bool
 */
function raptor_is_sending_form() {
    return defined( 'DOING_AJAX' ) && isset( $_REQUEST['action'] ) && $_SERVER['REQUEST_METHOD'] == 'POST' && isset( $_POST['raptor_form_id'] );
}


/**
 * Return the state of the lazy loading ability.
 * 
 * @since 1.1.x
 * @return bool
 */
function raptor_lazy_loading_enabled() {
    return apply_filters( 'raptor_lazy_loading_enabled', true );
}
