<?php
/**
 * Preload post thumbnail image
 */
function raptor_preload_post_thumbnail() {
    global $post;
    /**
     * Prevent preloading for specific content types or post types
     * 
     * Defaults to true becuase preload must be on an opt-in basis.
     */
    if ( apply_filters( 'raptor_preload_post_thumbnail_early_exit', true, $post ) ) {
        return;
    }
    /**
     * Set the size of the image
     */
    $image_size = apply_filters( 'raptor_preload_post_thumbnail_size', 'large', get_post_thumbnail_id( $post->ID ) );
    /**
     * Set the attachment ID that should be used
     */
    $thumbnail_id = apply_filters( 'raptor_preload_post_thumbnail_id', get_post_thumbnail_id( $post->ID ) );
    /**
     * Get the image, we should have everything we need now.
     */
    $image = wp_get_attachment_image_src( $thumbnail_id, $image_size );
    $src = '';
    $attr = [];
    $attr_string = '';

    $attachment = get_post( $thumbnail_id );

    if ( $image ) {
        list( $src, $width, $height ) = $image;

        $attr['src'] = $src;

        /**
         * The following code which generates the srcset is plucked straight
         * out of wp_get_attachment_image() for consistency as it's important
         * that the output matches otherwise the preloading could become ineffective.
         */
        $image_meta = wp_get_attachment_metadata( $thumbnail_id );
 
        if ( is_array( $image_meta ) ) {
            $size_array = [ absint( $width ), absint( $height ) ];
            $srcset     = wp_calculate_image_srcset( $size_array, $src, $image_meta, $thumbnail_id );
            $sizes      = wp_calculate_image_sizes( $size_array, $src, $image_meta, $thumbnail_id );

            if ( $srcset && ( $sizes || !empty( $attr['sizes'] ) ) ) {
                $attr['srcset'] = $srcset;

                if ( empty( $attr['sizes'] ) ) {
                    $attr['sizes'] = $sizes;
                }
            }
        }
        /**
         * Same filter applied in wp_get_attachment_image().
         * 
         * This should allow plugins that manipulate an images attributes to also take affect here.
         */
        $attr = apply_filters( 'wp_get_attachment_image_attributes', $attr, $attachment, $image_size );
        /**
         * Process all the necessary formatting to prepare for generating attributes string
         */
        $attr = array_intersect_key( $attr, array_flip( [ 'src', 'srcset', 'sizes' ] ) );
        $attr = array_map( 'esc_attr', $attr );

        $src = $attr['src'];
        unset( $attr['src'] );

        foreach ( $attr as $name => $value ) {
            $attr_string .= "image{$name}=" . '"' . $value . '" ';
        }    
    } else {
        /**
         * Early exit if no thumbnail set
         */
        return;
    }

    /**
     * Output the link HTML tag
     */
    printf( '<link rel="preload" as="image" href="%s" %s/>', $src, $attr_string );
}
add_action( 'wp_head', 'raptor_preload_post_thumbnail', 1 );
