<?php

namespace Raptor\Mods;
use WP_CLI;

class Mod {
    var $command = '';
    var $callable = null;

    function __construct( string $command, callable $callable = null, array $options = [] ) {
        $this->command = $command;
        $this->callable = $callable;

        $default_options = [
            'enable_cli' => true
        ];

        add_action( 'cli_init', [ $this, 'cli_init' ] );
    }


    function cli_init() {
        \WP_CLI::add_command( "raptor mod {$this->command}", [ $this, 'run' ] ); 
    }


    function run( $args, $assoc_args ) {
        call_user_func_array( $this->callable, [ $args, $assoc_args ] );
    }
}
