<?php 
namespace Raptor\Forms\Field_Type;

use Raptor\Forms\Field_Type;
use Raptor\Forms\Form;

class Submit extends Field_Type {
    /**
     * It'll be good to set field specific defaults here.
     */
    function __construct( array $settings, Form $form ) {
        parent::__construct( $form );

        $default_settings = array_merge(
            $this->universal_settings,
            [
                'label' => ''
            ]
        );

        $this->settings = wp_parse_args( $settings, $default_settings );
    }

    function render_field() {
        // Field attributes
        $attributes = $this->setup_attributes();

        printf( '<button type="submit" class="button" %s>%s</button>', $this->output_attributes( $attributes ), $this->label() );
    }
}
