<?php 
namespace Raptor\Forms\Field_Type;

use Raptor\Forms\Field_Type;
use Raptor\Forms\Form;

class Radio extends Field_Type {
    /**
     * It'll be good to set field specific defaults here.
     */
    function __construct( array $settings, Form $form ) {
        parent::__construct( $form );

        $default_settings = array_merge(
            $this->universal_settings,
            [
                'options' => []
            ]
        );

        $this->settings = wp_parse_args( $settings, $default_settings );
    }

    function render_field() {
        printf( '<fieldset name="%s" data-required="%s">', $this->settings['name'], $this->settings['required'] ? 'true' : 'false' );
        if ( !empty( $this->settings['label'] ) ) {
            printf( '<legend>%s</legend>', $this->label() );
        }

        $options = apply_filters( 'raptor_forms_radio_field_options', $this->settings['options'], $this );

        $i = 0;
        foreach ( $options as $option ) {
            $option_html_id = $this->html_id( '_' . $i . '_option' );

            $option_attributes = [
                'name' => $this->settings['name'],
                'id' => $option_html_id,
                'value' => isset( $option['value'] ) && !empty( $option['value'] ) ? $option['value'] : $option['label']
            ];

            if ( $this->settings['required'] ) {
                $option_attributes['required'] = '';
            }

            printf( 
                '<div class="radio-option">
                    <label for="%s">
                        <input type="radio" %s />
                        <span>%s</span>
                    </label>
                </div>', 
                $option_html_id, 
                $this->output_attributes( $option_attributes ),
                $option['label']
            );

            $i++;
        }

        echo '</fieldset>';
    }
}
