<?php 
namespace Raptor\Forms\Field_Type;

use Raptor\Forms\Field_Type;
use Raptor\Forms\Form;

class Checkbox extends Field_Type {
    /**
     * It'll be good to set field specific defaults here.
     */
    function __construct( array $settings, Form $form ) {
        parent::__construct( $form );

        $default_settings = array_merge(
            $this->universal_settings,
            [
                'multiple' => false,
                'options' => []
            ]
        );

        $this->settings = wp_parse_args( $settings, $default_settings );
    }

    function render_field() {
        
        if ( $this->settings['multiple'] && !empty( $this->settings['options'] ) ) {
            printf( '<fieldset name="%s" data-required="%s">', $this->settings['name'], $this->settings['required'] ? 'true' : 'false' );
            if ( !empty( $this->settings['label'] ) ) {
                printf( '<legend>%s</legend>', $this->label() );
            }

            $options = apply_filters( 'raptor_forms_checkbox_field_options', $this->settings['options'], $this );

            $i = 0;
            foreach ( $options as $option ) {
                $option_html_id = $this->html_id( '_' . $i . '_option' );

                $option_attributes = [
                    'name' => $this->settings['name'] . '[]',
                    'id' => $option_html_id,
                    'value' => isset( $option['value'] ) && !empty( $option['value'] ) ? $option['value'] : $option['label']
                ];

                if ( $this->settings['required'] ) {
                    $option_attributes['required'] = '';
                }

                echo '<div class="checkbox-option">';
                printf( '<input type="checkbox" %s />', $this->output_attributes( $option_attributes ) );
                printf( '<label for="%s">%s</label>', $option_html_id, $option['label'] );
                echo '</div>';

                $i++;
            }

            echo '</fieldset>';

        } else {
            // Field attributes
            $attributes = $this->setup_attributes();

            printf( '<input type="checkbox" %s />', $this->output_attributes( $attributes ) );
            printf( '<label for="%s">%s</label>', $this->html_id(), $this->label() );
        }
    }
}
