<?php
namespace Raptor\Forms;

class Field_Type {
    var $universal_settings;

    var $settings;

    var $form;

    function __construct( Form $form ) {
        $this->form = $form;

        $universal_settings = [
            'type' => '',
            'name' => '',
            'required' => false
        ];

        $this->universal_settings = $universal_settings;
    }

    function render() {
        $this->render_field_wrapper_open();
        $this->render_field();
        $this->render_field_wrapper_close();
    }

    function render_field_wrapper_open() {
        printf( '<div class="field field_type--%s field--%s">', $this->settings['type'], $this->settings['name'] );
    }

    function render_field() {
        if ( !empty( $this->settings['label'] ) ) {
            printf( '<label for="%s">%s</label>', $this->html_id(), $this->label() );
        }

        // Field attributes
        $attributes = $this->setup_attributes([
            'placeholder' => $this->settings['placeholder']
        ]);

        printf( '<input type="%s" class="form-input" %s />', $this->settings['type'], $this->output_attributes( $attributes ) );
    }

    function render_field_wrapper_close() {
        echo '</div>';
    }

    function html_id( string $suffix = '' ) {
        return 'form_' . $this->form->render_id . '-' . $this->settings['name'] . $suffix;
    }

    /**
     * Sets up the default attributes most field types need. Excludes radio and checkbox
     * 
     * @param array $unique_attributes
     * @return array
     */
    function setup_attributes( array $unique_attributes = [] ) {
        $attributes = array_merge(
            [
                'name' => $this->settings['name'],
                'id' => $this->html_id()
            ],
            $unique_attributes
        );

        if ( $this->settings['required'] ) {
            $attributes['required'] = '';
        }

        return apply_filters( 'raptor_forms_field_attributes', $attributes, $this );
    }


    /**
     * Output HTML attributes including bool.
     * 
     * @param array $attr
     */
    function output_attributes( array $attr ) {
        return raptor_output_attr( $attr, true );
    }


    /**
     * Field label inner HTML.
     * 
     * @return string
     */
    function label() {
        $label = $this->settings['label'];

        // Match Markdown links in the format [link text](URL)
        $pattern = '/\[(.*?)\]\((.*?)\)/';
        $replacement = '<a href="$2" target="_blank" rel="noreferrer noopener">$1</a>';

        // Replace Markdown links with HTML links
        $label = preg_replace( $pattern, $replacement, $label );

        if ( $this->settings['required'] ) {
            $label .= '&nbsp;<abbr class="required" title="required">*</abbr>';
        }

        return apply_filters( 'raptor_form_field_label', $label, $this );
    }
}
