<?php
/**
 * WYSIWYG editor
 */


/**  
 *  Filter the plugins in the WYSIWYG editor
 *
 *  @since 1.0
 *
 *  @param $plugin_array array The plugins used in the editor
 *  @return array The plugins used in the editor
 */
function raptor_editor( $plugin_array ) {
    $plugin_array['button_plugin'] = raptor_get_asset_url( 'assets/js/editor.js' );

    return $plugin_array;
}


/**  
 *  Add Raptor custom buttons to the WYSIWYG editor
 *
 *  @since 1.0
 *
 *  @param $buttons array The buttons used in the editor
 *  @return array The buttons used in the editor
 */
function raptor_editor_register_buttons( $buttons ) {
    array_push( $buttons, '|', 'button' );

    return $buttons;
}


/**  
 *  Add the Raptor WYSIWYG editor customizations 
 *
 *  @since 1.0
 */
function raptor_mce() {
    add_filter( 'mce_external_plugins', 'raptor_editor' );
    add_filter( 'mce_buttons', 'raptor_editor_register_buttons' );
}
add_action( 'admin_init', 'raptor_mce' );


/**  
 *  Filter the ACF editor to include Raptor buttons
 *
 *  @since 1.0
 *
 *  @param $toolbars array The toolbars used in ACF editor
 *  @return array The toolbars used in ACF editor
 */
function raptor_acf_editor_toolbar( $toolbars ) {
    $toolbars['Raptor Full'] = [];
    $toolbars['Raptor Basic'] = [];

    // Raptor Full Toolbar
    $toolbars['Raptor Full'][1] = [
        'formatselect',
        'bold',
        'italic',
        'bullist',
        'numlist',
        'alignleft',
        'aligncenter',
        'alignright',
        'link',
        'spellchecker',
        '|',
        'button'
    ];

    $toolbars['Raptor Full'][2] = [
        'strikethrough',
        'hr',
        'forecolor',
        'pastetext',
        'removeformat',
        'charmap',
        'outdent',
        'indent',
        'undo',
        'redo',
        'wp_help'
    ];

    // Raptor Basic Toolbar
    $toolbars['Raptor Basic'][1] = [
        'bold',
        'italic',
        '|',
        'alignleft',
        'aligncenter',
        'alignright',
        '|',
        'link',
        'spellchecker',
        '|',
        'button'
    ];

    return $toolbars;
}
add_filter( 'acf/fields/wysiwyg/toolbars', 'raptor_acf_editor_toolbar' );


/**  
 * Function to run on call to shortcode [button] - output button link
 *
 * @param array $atts
 * @return string The anchor link HTML
 */
function raptor_add_button( array $atts ) {
    /**
     * Filter the default attributes for the shortcode.
     * 
     * @param array
     */
    $atts_defaults = apply_filters(
        'raptor_button_atts_defaults',
        [
            'href' => '',
            'text' => '',
            'style' => 'fill',
            'color' => 'primary',
            'icon' => 'none',
            'icon-position' => 'right',
            'colour' => '',
            'classes' => '',
            'target' => '',
            'newtab' => ''
        ]
    );

    $atts = shortcode_atts( $atts_defaults, $atts );

    $a_attributes = [
        'href' => $atts['href'],
        'class' => 'button'
    ];

    if ( $atts['style'] != '' && $atts['style'] != $atts_defaults['style'] ) {
        $a_attributes['class'] .= sprintf( ' button--%1$s style-%1$s', $atts['style'] );
    }

    /**
     * Support English (UK) spelling of `colour`
     */

    if ( !empty( $atts['colour'] ) ) {
        $atts['color'] = $atts['colour'];
    }

    if ( $atts['color'] != '' && $atts['color'] != $atts_defaults['color'] ) {
        $a_attributes['class'] .= sprintf( ' color-%s', $atts['color'] );
    }

    if ( $atts['icon-position'] != '' && $atts['icon-position'] != 'right' ) {
        $a_attributes['class'] .= sprintf( ' icon-%s', $atts['icon-position'] );
    }

    if ( $atts['classes'] != '' ) {
        $a_attributes['class'] .= ' ' . $atts['classes'];
    }

    if ( $atts['target'] != '' || $atts['newtab'] == 'true' ) {
        $a_attributes['target'] = $atts['newtab'] ? '_blank' : $atts['target'];
    }

    if ( isset( $a_attributes['target'] ) && $a_attributes['target'] == '_blank' ) {
        $a_attributes['rel'] = 'noopener noferrer';
    }

    /**
     * Filter the icon for the button.
     * 
     * @param string $icon
     */
    $icon = get_raptor_icon( $atts['icon'], true );

    /**
     * Filter the attributes passed to the <a> element.
     * 
     * @param array $a_attributes
     * @param array $atts
     */
    $a_attributes = apply_filters( 'raptor_button_a_attributes', $a_attributes, $atts );

    /**
     * Filter the text for the button.
     * 
     * @param string $text
     */
    $text = apply_filters( 'raptor_button_text', $atts['text'], $atts );

    return sprintf( '<a %s><span class="button-inner">%s%s</span></a>', raptor_output_attr( $a_attributes ), $text, $icon );
}
add_shortcode( 'button', 'raptor_add_button' );
