<?php

use Raptor\Forms;

class Raptor {

    // Core theme details
    protected $raptor_name = 'Raptor Toolkit';
    protected $raptor_url = 'https://www.boxchilli.com';

    public $version = '1.5.4';


    // Contact Details
    public $email = '';
    public $phone = '';
    public $address = '';
    public $address_link = '';


    // --|  Dev Settings

    // Fonts
    public $fonts = [];

    /** @var Forms $forms */
    public $forms;
    
    /** @var object|null The tracking code snippets */
    public $tracking = null;

    /** @var Raptor\Headless|null */
    public $headless;

    /**  
     *  Assign values to the properties
     *
     *  @since 1.0
     */
    function __construct() {
        add_action( 'acf/init', [ $this, 'init' ], 30 );
    }


    /**
     * Init. This ensures ACF has initiated first.
     */
    function init() {
        $contact_details = raptor_get_settings( 'raptor', 'contact_details' );

        if ( $contact_details ) {
            if ( isset( $contact_details[ raptor_acf_get_field_selector( 'email_address' ) ] ) ) {
                $this->email = $contact_details[ raptor_acf_get_field_selector( 'email_address' ) ];
            }

            if ( isset( $contact_details[ raptor_acf_get_field_selector( 'phone_number' ) ] ) ) {
                $this->phone = $contact_details[ raptor_acf_get_field_selector( 'phone_number' ) ];
            }

            if ( isset( $contact_details[ raptor_acf_get_field_selector( 'address' ) ] ) ) {
                $this->address = $contact_details[ raptor_acf_get_field_selector( 'address' ) ];
            }
        }

        /**
         * Tracking.
         */
        $tracking = raptor_get_settings( 'raptor', 'tracking', false );

        if ( $tracking ) {
            foreach ( $tracking as $key => $value ) {
                $new_key = str_replace( raptor_acf_get_field_selector( 'tracking_' ), '', $key );

                if ( $new_key !== $key ) {
                    $tracking[ $new_key ] = $value;
                    unset( $tracking[ $key ] );
                }
            }

            $this->tracking = $tracking;

            if ( !isset( $this->tracking['always_enabled'] ) ) {
                $this->tracking['always_enabled'] = apply_filters( 'raptor_tracking_always_enabled', false );
            }

            $this->tracking['enabled'] = wp_get_environment_type() === 'production';

            if ( $this->tracking['always_enabled'] ) {
                $this->tracking['enabled'] = true;
            }
        }
    }


    /**  
     *  Get the value from an ACF option field
     *
     * @since 1.0
     * @deprecated
     * 
     * @param string $value The name of the ACF option field
     * @param bool $format
     * @return mixed|bool The value of the field if found, or false
     */
    public function get_acf_value( string $value, bool $format = true ) {
        if ( function_exists( 'get_field' ) ) {
            return get_field( $value, 'option', $format );
        }

        return false;
    }


    /**  
     *  Echo the value from an ACF option field
     *
     *  @since 1.0
     *  @deprecated
     * 
     *  @param string $value The name of the ACF option field
     *  @return mixed|bool The value of the field if found, or false
     */
    public function acf_value( string $value ) {
        if ( function_exists( 'the_field' ) ) {
            if ( get_field( $value, 'option' ) ) {
                the_field( $value, 'option' );
            }
        }

        return false;
    }

    /**  
     *  Echo a property value
     *
     *  @since 1.0
     *  @param string $value The name of the property
     */
    public function the( $value ) {
        echo $this->$value;
    }


    /**  
     *  Return a property value
     *
     *  @since 1.0
     *  @param string $value The name of the property
     *  @return mixed The property value
     */
    public function get( $value ) {
        return $this->$value;
    }


    /**
     * Check if a module is enabled.
     * 
     * @param string $module
     * @return bool
     */
    function module_enabled( string $module ) {
        $all_modules = [
            'forms' => true,
            'headless' => false
        ];

        if ( !isset( $all_modules[ $module ] ) ) {
            return false;
        }

        /**
         * Temporary... headless will be controlled via PHP constants.
         */
        if ( $module == 'headless' ) {
            if ( is_flex_active() ) {
                $all_modules['headless'] = true;
            }
        }

        if ( $module == 'forms' ) {
            $all_modules['forms'] = !is_shiftr_active();
        }

        return apply_filters( "raptor/module_enabled/$module", $all_modules[ $module ] );
    }
}


/**
 * For backwards compatability where global is called.
 */
$GLOBALS['raptor'] = new Raptor();

/**  
 *  Return the $raptor instance
 *
 *  @return object The $raptor instance
 */
function raptor() {
    global $raptor;

    if ( !isset( $raptor ) ) {
        $raptor = new Raptor();
    }

    return $raptor;
}
