<?php
namespace Raptor;
/**
 * Connect to the Raptor API.
 */
class API {
    /**
     * Make a request to the Raptor API.
     * 
     * @deprecated Use API::post() instead
     * @param string $endpoint
     * @param array $body
     * @return mixed
     */
    static function request( string $endpoint, array $body = [], array $args = [] ) {
        return self::post( $endpoint, $body, $args );
    }


    /**
     * Make a POST request to the Raptor API.
     * 
     * @param string $endpoint
     * @param array $body
     * @param array $args
     * @return mixed
     */
    static function post( string $endpoint, array $body = [], array $args = [] ) {
        $response = wp_remote_post(
            raptor_get_api_url( $endpoint ),
            array_merge(
                [
                    'headers' => [
                        'Content-Type' => 'application/json'
                    ],
                    'body' => json_encode( $body )
                ],
                $args
            )
        );

        if ( is_wp_error( $response ) ) {
            return $response;
        }

        $content_type = wp_remote_retrieve_header( $response, 'content-type' );
        $body = wp_remote_retrieve_body( $response );

        if ( stripos( $content_type, 'application/json' ) !== false ) {
            $body = json_decode( $body, true );
        }

        return $body;
    }


    /**
     * Make a GET request to the Raptor API.
     * 
     * @param string $endpoint
     * @param array $body
     * @param array|string|WP_Error
     */
    static function get( string $endpoint, array $search_params = [], array $args = [] ) {
        $url = add_query_arg( $search_params, raptor_get_api_url( $endpoint ) );

        $response = wp_remote_get(
            $url,
            $args
        );

        if ( is_wp_error( $response ) ) {
            return $response;
        }

        $content_type = wp_remote_retrieve_header( $response, 'content-type' );
        $body = wp_remote_retrieve_body( $response );

        if ( stripos( $content_type, 'application/json' ) !== false ) {
            /** @var array */
            $body = json_decode( $body, true );
        }

        return $body;
    }
}
