<?php


require_once( RAPTOR_INC . '/admin/raptor-admin-helpers.php' );


/**  
 *  Used to check if Raptor has already been installed and activated
 *
 *  @since 1.0
 *
 *  @return bool
 */
function raptor_is_installed() {
    if ( !get_option( '__raptor__' ) ) {
        // Display welcome notice for install
        add_action( 'admin_notices', 'raptor_notice_installed' );
        // Add option as false so install doesn't run again
        add_option( '__raptor__', true );

        return false;
    }

    return true;
};


/**  
 *  Get the welcome notice HTML
 *
 *  @since 1.0
 */
function raptor_notice_installed() {
    raptor_get_admin_notice_html( 'welcome' );
}


// Register all core Advanced Custom Fields
if ( function_exists( 'acf' ) ) {

    // Tell Raptor that ACF plugin is available
    $raptor_has_acf = true;

} else {
    // Tell Raptor that ACF plugin is unavailable
    $raptor_has_acf = false;
    
    /**  
     *  Get the admin notice for no ACF
     *
     *  @since 1.0
     */
    function raptor_notice_error_no_acf() {
        raptor_get_admin_notice_html( 'error-no-acf' );
    }

    add_action( 'admin_notices', 'raptor_notice_error_no_acf' );
}
