<?php
/**  
 *  Output the HTML of an admin notice, the filename prefix 'notice-' and file extension
 *  should be excluded on function call
 *
 *  @since 1.0
 *
 *  @param string $file The suffix of the file name
 *  @return bool The HTML output on success, or false if file not found
 */
function raptor_get_admin_notice_html( $file = '' ) {
    $file_path = RAPTOR_INC . '/admin/html/notice-' . $file . '.php';

    if ( file_exists( $file_path ) ) {
        include( $file_path );
    }

    return false;
}


/**  
 *  Output HTML from any file within the /inc/html directory
 *
 *  @since 1.0
 *
 *  @param string $file The file name to include
 *  @return bool The HTML output on success, or false if file not found
 */
function raptor_get_html( $file = '' ) {
    $file_path = RAPTOR_INC . '/admin/html/' . $file . '.php';

    if ( file_exists( $file_path ) ) {
        include_once $file_path;
    }

    return false;
}
