<?php
/**
 * Raptor Forms - settings page
 */
?>
<div class="wrap">
    
    <h1>Contact Form Settings</h1>

    <div class="raptor-box">
        <h2>Default Settings</h2>

        <?php do_action( 'admin_notices' ); ?>

        <form method="post">
            <div class="raptor-textarea">
                <label>Recepients</label>
                <span>Separate email addresses with a new line</span>
                <textarea name="raptor_form_default_recepients" rows="4"><?php echo esc_html( get_option( 'raptor_form_default_recepients' ) ); ?></textarea>
            </div>

            <div class="raptor-input">
                <label>Subject</label>
                <input type="text" name="raptor_form_default_subject" value="<?php echo esc_attr( get_option( 'raptor_form_default_subject' ) ); ?>">
            </div>


            <div class="raptor-separator"></div>


            <div class="raptor-subheading">
                <h3>Success Message</h3>
                <span>The message shown when the submission was successful</span>
            </div>

            <div class="raptor-input">
                <label>Heading</label>
                <input type="text" name="raptor_form_message_success_heading" value="<?php echo esc_attr( get_option( 'raptor_form_message_success_heading' ) ); ?>">
            </div>

            <div class="raptor-input">
                <label>Body</label>
                <input type="text" name="raptor_form_message_success_body" value="<?php echo esc_attr( get_option( 'raptor_form_message_success_body' ) ); ?>">
            </div>


            <div class="raptor-separator"></div>


            <div class="raptor-subheading">
                <h3>Error Message</h3>
                <span>The message shown when the submission failed</span>
            </div>

            <div class="raptor-input">
                <label>Heading</label>
                <input type="text" name="raptor_form_message_error_heading" value="<?php echo esc_attr( get_option( 'raptor_form_message_error_heading' ) ); ?>">
            </div>

            <div class="raptor-input">
                <label>Body</label>
                <input type="text" name="raptor_form_message_error_body" value="<?php echo esc_attr( get_option( 'raptor_form_message_error_body' ) ); ?>">
            </div>


            <div class="raptor-separator"></div>


            <div class="raptor-subheading">
                <h3>reCAPTCHA</h3>
            </div>

            <div class="raptor-input">
                <label>Site Key</label>
                <input type="text" name="raptor_form_recaptcha_site_key" value="<?php echo esc_attr( get_option( 'raptor_form_recaptcha_site_key' ) ); ?>">
            </div>

            <div class="raptor-input">
                <label>Secrey Key</label>
                <input type="password" name="raptor_form_recaptcha_secret_key" value="<?php echo esc_attr( get_option( 'raptor_form_recaptcha_secret_key' ) ); ?>">
            </div>


            <div class="raptor-submit">
                <?php submit_button(); ?>
            </div>
        </form>
    </div>
</div>  
