<?php
namespace Raptor;

class Activate {
    function __construct() {
        register_activation_hook( RAPTOR_PLUGIN_FILE, [ $this, 'activate' ] );
    }


    function activate() {
        $this->upload_placeholder_image();
    }


    function upload_placeholder_image() {
        $api_url = raptor_get_api_url( 'images/raptor-preview-placeholder.jpg' );
        $placeholder_id = $this->upload_media( str_replace( '/api', '', $api_url ) );

        update_field( 'block_previews_placeholder_images', [ $placeholder_id ], 'option' );
    }


    /**
     * Uploads an image and associates to the product.
     * 
     * @see https://wordpress.stackexchange.com/questions/256830/programmatically-adding-images-to-media-library
     * 
     * @param string $image_url The image URL
     * @return integer The attachment ID
     */
    function upload_media( string $image_url ) {
        $upload_dir = wp_upload_dir();

        $image_data = file_get_contents( $image_url );

        if ( $image_data === false ) {
            return false;
        }

        $filename = basename( $image_url );

        if ( wp_mkdir_p( $upload_dir['path'] ) ) {
            $file = $upload_dir['path'] . '/' . $filename;
        } else {
            $file = $upload_dir['basedir'] . '/' . $filename;
        }

        file_put_contents( $file, $image_data );

        $wp_filetype = wp_check_filetype( $filename, null );

        $attachment = [
            'post_mime_type' => $wp_filetype['type'],
            'post_title' => sanitize_file_name( $filename ),
            'post_content' => '',
            'post_status' => 'inherit'
        ];

        $attachment_id = wp_insert_attachment( $attachment, $file );

        require_once( ABSPATH . 'wp-admin/includes/image.php' );

        $attachment_data = wp_generate_attachment_metadata( $attachment_id, $file );
        wp_update_attachment_metadata( $attachment_id, $attachment_data );

        return $attachment_id;
    }
}

new Activate();
