<?php


class acf_field_icon_picker extends acf_field {
    /**
     * Store plugin settings (url, path, version) as a reference for later use with assets
     * @var array
     */
    protected array $settings = [];
	
    function __construct( $settings ) {
        /**
         * @var string $name Single word, no spaces. Underscores allowed
         */
        $this->name = 'icon_picker';
		
        /**
         * @var string $label Multiple words, can include spaces, visible when selecting a field type
         */
        $this->label = 'Icon Picker';
		
        /**
         *  @var string $category basic | content | choice | relational | jquery | layout | CUSTOM GROUP NAME
         */
        $this->category = 'choice';
		
        /**
         * @var array $defaults Array of default settings which are merged into the field object. These are used later in settings
         */
        $this->defaults = [
            'font_size'	=> 14,
        ];
		
        /**
         * @var array $l10n Array of strings that are used in JavaScript. This allows JS strings to be translated in PHP and loaded via:
         * var message = acf._e('FIELD_NAME', 'error');
         */
        $this->l10n = [];
		
        /**
         * @var array $settings Store plugin settings (url, path, version) as a reference for later use with assets
         */
        $this->settings = $settings;
		
        parent::__construct();
    }
	
	
    /*
    *  Create the HTML interface for your field
    */
    function render_field( $field ) {
        /**
         * Populate the icons here.
         */
        $icons = apply_filters( 'raptor_acf_icon_picker_field_icons', [] );

        $value = acf_get_array( $field['value'] );
        $choices = acf_get_array( array_map( function( $icon ) {
            return $icon['label'];
        }, $icons ) );

        asort( $choices );

        $choices = [ '' => "- Please select an icon -" ] + $choices;

        // placeholder
        if ( empty( $field['placeholder'] ) ) {
            $field['placeholder'] = _x( 'Select', 'verb', 'acf' );
        }
        
        if ( empty( $value ) ) {
            $value = [''];
        }

        echo "<div class='acf-field acf-field-icon-picker' 
           data-name='{$field['label']}' 
           data-type='select' 
           data-key='{$field['key']}'>";

        // hidden input is needed to allow validation to see <select> element with no selected value
        acf_hidden_input([
            'id'	=> $field['id'] . '-input',
            'name'	=> $field['name']
        ]);
		

        // vars
        $select = [
            'id'				=> $field['id'],
            'class'				=> $field['class'],
            'name'				=> $field['name'],
            'data-ui'			=> 1,
            'data-ajax'			=> 0,
            'data-multiple'		=> 0,
            'data-placeholder'	=> $field['placeholder'],
            'data-allow_null'	=> 1
        ];

        // append
        $select['value'] = $value;
        $select['choices'] = $choices;

        acf_select_input( $select );

        echo "</div>";
    }
	
		
    /*
    *  This action is called in the admin_enqueue_scripts action on the edit screen where your field is created.
    *  Use this action to add CSS + JavaScript to assist your render_field() action.
    */
    function input_admin_enqueue_scripts() {
        $version = $this->settings['version'];

        if ( !acf_get_setting( 'enqueue_select2' ) ) return;
		
        global $wp_scripts, $wp_styles;
		
        // vars
        $min = defined( 'SCRIPT_DEBUG' ) && SCRIPT_DEBUG ? '' : '.min';
        $major = acf_get_setting( 'select2_version' );
        $version = '';
        $script = '';
        $style = '';
		
        // attempt to find 3rd party Select2 version
        // - avoid including v3 CSS when v4 JS is already enququed
        if ( isset( $wp_scripts->registered['select2'] ) ) {
            $major = (int) $wp_scripts->registered['select2']->ver;
        }
		
        // v4
        if ( $major == 4 ) {
            $version = '4.0';
            $script = acf_get_url( "assets/inc/select2/4/select2.full{$min}.js" );
            $style = acf_get_url( "assets/inc/select2/4/select2{$min}.css" );
		
            // v3
        } else {
            $version = '3.5.2';
            $script = acf_get_url( "assets/inc/select2/3/select2{$min}.js" );
            $style = acf_get_url( "assets/inc/select2/3/select2.css" );
        }
		
        // enqueue
        wp_enqueue_script( 'select2', $script, [ 'jquery' ], $version );
        wp_enqueue_style( 'select2', $style, '', $version );

        // localize
        acf_localize_data( [
                'iconPicker' => [
                    'availableIcons' => apply_filters( 'raptor_acf_icon_picker_field_icons', [] )
                ]
            ]
        );
    }
	

    /*
    *  This filter is applied to the $value after it is loaded from the db
    */
    function load_value( $value, $post_id, $field ) {
        return $value;
    }
	
	
    /*
    *  This filter is applied to the $value before it is saved in the db
    */
    function update_value( $value, $post_id, $field ) {
        return $value;
    }
	
	
    /*
    *  This filter is appied to the $value after it is loaded from the db and before it is returned to the template
    */
    function format_value( $value, $post_id, $field ) {
        if ( empty( $value ) ) {
            return $value;
        }
		
        return get_raptor_icon( $value );
    }
}

new acf_field_icon_picker( $this->settings );
