<?php
/**
 * Raptor ACF
 * 
 * The Advanced Custom Fields in Raptor is controlled via PHP: https://www.advancedcustomfields.com/resources/register-fields-via-php/
 * 
 * While this may seem like more effort, it actually makes working with the Flexi Blocks Builder incredibly easier.
 * Raptor_ACF is a framework of sorts which makes working with ACF via PHP simpler and takes much of the effort
 * off the developers hands.
 * 
 * Another key reason for using PHP is that a Flexi Block, described below, will share settings across multiple 
 * types of Blocks, which is a massive pain to control over the GUI or JSON and can only be done manually. Working 
 * over PHP means settings only need to be setup once, and can be instantly shared across any Block.
 * 
 * Blocks:
 * A `Block` is a layout which belongs within the context of a Flexible Content field.
 * Blocks are registered in blocks/blocks.php by calling a new instance of the Flexi_Block class. Whereby
 * a new Flexi_Block instance is added to the `raptor_blocks_library` global. A Block exists independantly of 
 * a Flexi_Builder (Flexible Content field) and can be added to multiple Builders.
 * 
 * Builders:
 * A Flexi Blocks Builder, or Builder for short, is a Flexible Content field which makes it very easy to add
 * Blocks to it. By default, all available Blocks are added to a Builder, however it is possible to assign
 * only a selection of Blocks. A Builder exists independantly of an ACF group, as it is only a field.
 * 
 * Groups:
 * A group is just that, it's an ACF group. It simply makes it easier to create a new group.
 */
namespace Raptor\ACF;

/**
 * The Raptor Blocks Library stores instances of all blocks 
 * available to the Raptor/ACF Flexi eco-system. This library makes it
 * simple to add blocks to multiple ACf field groups without redeclaring 
 * any block or its settings.
 */
$GLOBALS['raptor_blocks_library'] = [];
$GLOBALS['raptor_builder_library'] = [];
$GLOBALS['raptor_groups_library'] = [];
$GLOBALS['raptor_acf_setting_groups'] = [];
$GLOBALS['raptor_acf_field_key_store'] = [];


require( RAPTOR_ACF . 'helper-functions.php' );
require( RAPTOR_ACF . 'blocks-library.php' );
require( RAPTOR_ACF . 'field-types.php' );
require( RAPTOR_ACF . 'class-flexi-block.php' );
require( RAPTOR_ACF . 'class-flexi-builder.php' );
require( RAPTOR_ACF . 'class-raptor-acf-group.php' );
require( RAPTOR_ACF . 'admin.php' );
require( RAPTOR_ACF . 'graphql.php' );
require( RAPTOR_ACF . 'flexi-block-preview.php' );
require( RAPTOR_ACF . 'flexi-block-library-autoload.php' );
require( RAPTOR_ACF . 'field-icon-picker/field-icon-picker.php' );

/**
 * Init all the groups
 */
add_action( 'acf/init', function() {
    /**
     * Include built-in groups.
     */
    include( plugin_dir_path( RAPTOR_PLUGIN_FILE ) . 'acf/groups/options-raptor.php' );
    include( plugin_dir_path( RAPTOR_PLUGIN_FILE ) . 'acf/groups/options-flexi.php' );
    include( plugin_dir_path( RAPTOR_PLUGIN_FILE ) . 'acf/groups/options-forms.php' );
    include( plugin_dir_path( RAPTOR_PLUGIN_FILE ) . 'acf/groups/single-post.php' );
    include( plugin_dir_path( RAPTOR_PLUGIN_FILE ) . 'acf/groups/single-flexi_template.php' );
    include( plugin_dir_path( RAPTOR_PLUGIN_FILE ) . 'acf/groups/single-flexi_global.php' );
}, 15 );

/**
 * Init all the groups
 */
add_action( 'acf/init', function() {
    global $raptor_groups_library;

    /**
     * Manage the ACF groups before loading.
     * 
     * @param array $raptor_groups_library
     */
    $groups = apply_filters( 'raptor_acf_groups', $raptor_groups_library );

    foreach ( $raptor_groups_library as $key => $group ) {
        $group->acf_add_local_field_group();
    }

    /**
     * Set Google Maps API key
     */
    if ( defined( 'GOOGLE_API_KEY' ) ) {
        acf_update_setting( 'google_api_key', GOOGLE_API_KEY );
    }
}, 20 );


/**  
 * Disable the ACF admin for all users.
 * 
 * The admin will only be shown if the license is not configured.
 */
add_filter( 'acf/settings/show_admin', function() {
    return !acf_pro_get_license();
});
