<?php

use Raptor\ACF\Utils as Utils;
use Raptor\ACF\Group;
use Raptor\ACF\Flexi_Builder;
use Raptor\ACF\Field_Types;

/**
 * Flexi Page Template
 */
new Group(
    'flexi_page_template',
    [
        'title'     => 'Flexi Blocks Builder',
        'fields'    => [
            Utils\get_builder( 'main' )
        ],
        'location'  => [
            [
                [
                    'param'     => 'post_type',
                    'operator'  => '==',
                    'value'     => 'flexi_template'
                ]
            ]
        ]
    ]
);


new Group(
    'flexi_page_template-settings',
    [
        'title'     => 'Settings',
        'fields'    => [
            Field_Types\select_field(
                'Automatically Apply',
                [
                    'name' => 'auto_apply',
                    'instructions' => 'Creating a new page will automatically load this template for the selected post types.',
                    'choices' => ( function() {
                        return apply_filters( 'raptor_flexi_template_auto_apply_choices', [ 'page' => 'Pages' ] );
                    } )(),
                    'allow_null' => true
                ]
            )
        ],
        'position' => 'side',
        'location'  => [
            [
                [
                    'param'     => 'post_type',
                    'operator'  => '==',
                    'value'     => 'flexi_template'
                ]
            ]
        ]
    ]
);
