/* eslint-disable */
const path = require('path');
const MiniCssExtractPlugin = require('mini-css-extract-plugin');

const mode = process.env.NODE_ENV || 'development';
const proxyUrl = 'http://raptor-dev.test';

module.exports = {
  mode,
  resolve: {
    extensions: ['*', '.js'],
  },
  cache: false,
  optimization: {
    runtimeChunk: process.env.NODE_ENV === 'production' ? false : 'single',
  },
  devtool: mode === 'development' ? 'source-map' : false,
  entry: {
    frontend: [
      './src/scss/main.scss',
      './src/js/frontend/core.js',
      './src/js/frontend/autoload-components.js',
      './src/js/frontend/site-header.js',
      './src/js/frontend/main.js',
    ],
    form: './src/scss/packets/form.scss',
    glide: './src/js/frontend/glide.js',
  },
  output: {
    path: path.resolve(__dirname, 'assets'),
    publicPath: '/assets',
    filename: 'js/[name].js',
  },
  devServer: {
    open: {
      app: {
        name: 'Chrome',
      },
    },
    allowedHosts: 'all',
    port: 3000,
    host: 'localhost',
    client: {
      overlay: {
        errors: true,
        warnings: false,
      },
      logging: 'info',
    },
    hot: true,
    static: false,
    devMiddleware: {
      index: false, // specify to enable root proxying
    },
    proxy: [
      {
        context: () => true,
        target: proxyUrl,
        secure: false,
        changeOrigin: true,
        logger: console,
        onProxyRes: (proxyRes, req, res) => {
          if (proxyRes?.headers?.['content-type']?.match(/text\/html/)) {
            const _write = res.write;
            /**
             * Modify asset URLs in HTML to use files in memory served by DevServer.
             */
            res.write = (data) => {
              const host = proxyUrl.replace(/http:\/\//g, '');
              const pattern = new RegExp(host, 'g');
              let newData = data.toString().replace(pattern, req.headers.host);
              newData = newData
                .toString()
                .replace(
                  /wp-content\/themes\/raptor-frontend\/assets\/(css|js)/g,
                  'assets/$1'
                );
  
              _write.call(res, newData);
            }
          }
        }
      }
    ],
    headers: {
      'x-raptor-mode': 'development',
    },
    watchFiles: ['../../../wp-config.php', './**/*.php', './src/js/**/*.js'],
  },
  module: {
    rules: [
      {
        test: /\.s[ac]ss$/i,
        use: [
          MiniCssExtractPlugin.loader,
          {
            loader: 'css-loader',
            options: {
              url: false,
            },
          },
          'postcss-loader',
          'sass-loader',
        ],
      },
      {
        test: /\.js$/,
        exclude: /node_modules/,
        use: {
            loader: 'swc-loader',
            options: {
              jsc: {
                target: 'es2015'
              }
            }
          }
      },
    ],
  },
  plugins: [
    new MiniCssExtractPlugin({
      filename: 'css/[name].css',
    }),
  ],
  stats: 'minimal',
};
