/**
 * This core file is for working on the core components 
 * of the theme.
 * 
 * It's unlikely you would need to alter this file
 */
import CookieNotice from '../lib/cookie'


/**
 * Load core components
 */
CookieNotice()


/**
 * Generate Flexi Blocks Builder `data-prev-block` and `data-next-block` atributes.
 */
;(() => {
  const flexiBlocksBuilder = document.querySelector('.flexi-blocks-builder')

  if (!flexiBlocksBuilder) {
    return
  }
    
  const blocks = [...flexiBlocksBuilder.children]

  /**
   * Extract the block name from the class in the wrapper element.
   * 
   * @param {HTMLElement} el The block wrapper
   * @returns The block name
   */
  function getBlockName(el) {
    return el.classList.value.match(/block--([a-zA-Z0-9-_]+)/)?.[1]
  }

  blocks.forEach((block, index) => {
    if (blocks[index - 1]) {
      block.setAttribute('data-prev-block', getBlockName(blocks[index - 1]))
    }

    if (blocks[index + 1]) {
      block.setAttribute('data-next-block', getBlockName(blocks[index + 1]))
    }
  })
})()


/**
 * Post archive ordering
 */
;(() => {
  const form = document.querySelector('form.raptor-orderby')

  if (!form) {
    return
  }

  form['raptor-orderby'].addEventListener('change', event => {
    const value = event.target.value

    if (value.match(/|/)) {
      const [orderby, order] = value.split('|')

      event.target.value = ''
      form.orderby.value = orderby
      form.order.value = order
    }
    form.submit()
  })
})()


/**
 * Post archive filtering (taxonomy)
 */
;(() => {
  const form = document.querySelector('form.raptor-taxonomy-filter')

  if (!form) {
    return
  }

  form.querySelector('select').addEventListener('change', event => {
    location.href = event.target.value
  })
})()
