import Form from '../components/form'
import Accordion from '../components/accordion'
import Tabs from '../components/tabs'
/**
 * This file is for auto-loading components only. 
 * 
 * It targets components by "data-raptor-<COMPONENT>" attribute
 */
(() => {
  if (document.querySelector('[data-raptor-form]')) {
    const forms = document.querySelectorAll('[data-raptor-form]') || []
    
    forms.forEach(el => {
      const f = new Form(el)
      f.init()
    })
  }
    
  if (document.querySelector('[data-raptor-accordion]')) {
    const accordions = document.querySelectorAll('[data-raptor-accordion]') || []
        
    accordions.forEach(el => {
      const a = new Accordion(el)
      a.init()
    })
  }
    
  if (document.querySelector('[data-raptor-tabs]')) {
    const tabs = document.querySelectorAll('[data-raptor-tabs]') || []
        
    tabs.forEach(el => {
      const t = new Tabs(el)
      t.init()
    })
  }
})()
