<?php
/**
 * @var string $post_type
 * @var string $taxonomy
 */
$terms = get_terms([
    'taxonomy' => $taxonomy,
    'hide_empty' => false
]);

$queried_object = get_queried_object();
$post_type_object = get_post_type_object( $post_type );

$terms = array_filter( $terms, function( $term ) {
    return $term->slug !== 'uncategorized';
});

if ( count( $terms ) === 0 ) {
    return;
}

?>
<form class="raptor-taxonomy-filter">
    <select name="<?php echo $taxonomy ?>" onchange="location.href=this.value">
        <?php
        printf(
            '<option value="%s">%s</option>',
            get_post_type_archive_link( $post_type ),
            $post_type_object->labels->all_items
        );

        foreach ( $terms as $term ) {
            printf(
                '<option value="%s"%s>%s</option>',
                get_term_link( $term, $taxonomy ),
                selected( $term->name, $queried_object instanceof WP_Term ? $queried_object->name : false, false ),
                $term->name
            );
        }
        ?>
    </select>
</form>
