<?php
/**
 * @var string $post_type
 * @var string $taxonomy
 */
$orderby = get_query_var( 'orderby', 'date' );
$order = get_query_var( 'order', 'DESC' );

$values = [
    'date|DESC' => 'Sort by latest',
    'date|ASC' => 'Sort by oldest',
    'title|ASC' => 'Sort by A-Z',
    'title|DESC' => 'Sort by Z-A'
];
?>
<form class="raptor-orderby">
    <select name="raptor-orderby">
        <?php
        foreach ( $values as $value => $title ) {
            printf(
                '<option value="%s" %s>%s</option>',
                $value,
                selected( $value, "$orderby|$order", false ),
                $title
            );
        }
        ?>
    </select>
    <input type="hidden" name="orderby" value="date">
    <input type="hidden" name="order" value="DESC">
</form>
