<?php 
/**
 * Default archive template.
 */
get_header();

?>

<main class="site-main" id="main-content">
    <?php
    raptor_hero(
        'standard',
        [
            'attachment_id' => raptor_get_archive_thumbnail_id(),
            'title' => raptor_archive_title( false ),
            'content' => raptor_archive_description( false )
        ]
    );
    ?>

    <section class="site-section posts-loop">
        <div class="container">
            <div class="posts-sorting">
                <?php
                raptor_get_template(
                    'taxonomy-filter.php',
                    [
                        'post_type' => 'post',
                        'taxonomy' => 'category'
                    ]
                );

                raptor_get_template(
                    'orderby.php',
                    [
                        'post_type' => 'post',
                        'taxonomy' => 'category'
                    ]
                );
                ?>
            </div>
            
            <?php if ( have_posts() ) : ?>
                <ul class="posts loop">
                    <?php
                    while ( have_posts() ) {
                        the_post();

                        raptor_get_template( 'content-post.php' );
                    }

                    wp_reset_postdata();
                    ?>
                </ul>

                <?php raptor_pagination(); ?>
            <?php endif; ?>

        </div>
    </section>
</main>
    

<?php get_footer(); ?>
