<?php
/**  
 *  Register all nav menu locations
 */
function raptor_register_nav_locations() {
    // phpcs:disable PEAR.Functions.FunctionCallSignature
    register_nav_menus([
        'header-primary'    => 'Header',
        'footer-1'          => 'Footer 1',
        'footer-2'          => 'Footer 2'
    ]);
    // phpcs:enable PEAR.Functions.FunctionCallSignature
}
add_action( 'init', 'raptor_register_nav_locations' );


/**
 * Main site menu
 */
function raptor_nav_primary() {
    // phpcs:disable PEAR.Functions.FunctionCallSignature
    wp_nav_menu([
        'container'         => 'nav',
        'container_class'   => 'nav-primary',
        'menu_class'        => '',
        'menu_id'           => 'nav-primary',
        'theme_location'    => 'header-primary',
        'depth'             => 3,
        'fallback_cb'       => false,
        'walker'            => new Raptor_Nav_Walker()
    ]);
    // phpcs:enable PEAR.Functions.FunctionCallSignature
}


/**
 * Main site menu, mobile version
 */
function raptor_nav_primary_mobile() {
    // phpcs:disable PEAR.Functions.FunctionCallSignature
    wp_nav_menu([
        'container'         => 'nav',
        'container_class'   => 'nav-primary-mobile',
        'menu_class'        => '',
        'menu_id'           => 'nav-primary-mobile',
        'theme_location'    => 'header-primary',
        'depth'             => 3,
        'fallback_cb'       => false,
        'walker'            => new Raptor_Nav_Primary_Mobile_Walker()
    ]);
    // phpcs:enable PEAR.Functions.FunctionCallSignature
}


/**
 * Footer menu 1
 */
function raptor_nav_footer_1() {
    // phpcs:disable PEAR.Functions.FunctionCallSignature
    wp_nav_menu([
        'container'         => 'nav',
        'container_class'   => 'nav-footer',
        'menu_class'        => '',
        'menu_id'           => '',
        'theme_location'    => 'footer-1',
        'depth'             => 2,
        'fallback_cb'       => false,
        'walker'            => new Raptor_Nav_Walker()
    ]);
    // phpcs:enable PEAR.Functions.FunctionCallSignature
}

/**
 * Footer menu 2
 */
function raptor_nav_footer_2() {
    // phpcs:disable PEAR.Functions.FunctionCallSignature
    wp_nav_menu([
        'container'         => 'nav',
            'container_class'   => 'nav-footer',
            'menu_class'        => '',
            'menu_id'           => '',
            'theme_location'    => 'footer-2',
            'depth'             => 2,
            'fallback_cb'       => false,
            'walker'            => new Raptor_Nav_Walker()
    ]);
    // phpcs:enable PEAR.Functions.FunctionCallSignature
}


/**
 * Raptor nav walker.
 */
class Raptor_Nav_Walker extends Walker_Nav_menu {
    /**
     * Starts the element output.
     * 
     * @param string    $output
     * @param WP_Post   $item
     * @param int       $depth
     * @param stdClass  $args
     * @param int       $current_object_id
     */
    function start_el( &$output, $menu_item, $depth = 0, $args = null, $current_object_id = 0 ) {
        $output .= sprintf( '<li class="%s">', join( ' ', $menu_item->classes ) );
        $output .= sprintf( '<a %s>%s</a>', raptor_output_attr( $this->get_link_attributes( $menu_item ) ), $menu_item->title );

        if ( $depth > 0 ) {
            $output .= $args->walker->has_children ? sprintf( '<button aria-label="%s menu"></button>', $menu_item->title ) : '';
        }
    }

    /**
     * Starts the list before the elements are added.
     * 
     * @param string    $output
     * @param int       $depth
     * @param stdClass  $args
     */
    function start_lvl( &$output, $depth = 0, $args = null ) {
        $indent = str_repeat( "\t", $depth );
        $output .= "\n$indent<ul class=\"sub-menu\">";
    }

    /**
     * Build array of attributes for the link element.
     * 
     * @since 1.1.0
     * 
     * @param WP_Post $menu_item
     * @return array
     */
    function get_link_attributes( WP_Post $menu_item ) {
        $attributes = [
            'href' => $menu_item->url
        ];

        if ( $menu_item->current ) {
            $attributes['aria-current'] = 'page';
        }

        if ( $menu_item->attr_title ) {
            $attributes['title'] = $menu_item->attr_title;
        }

        if ( $menu_item->target ) {
            $attributes['target'] = $menu_item->target;
            $attributes['rel'] = 'noreferrer';
        }

        return $attributes;
    }
}


/**
 * Mobile menu nav walker.
 */
class Raptor_Nav_Primary_Mobile_Walker extends Raptor_Nav_Walker {
    /**
     * Starts the element output.
     * 
     * @param string    $output
     * @param WP_Post   $item
     * @param int       $depth
     * @param stdClass  $args
     * @param int       $current_object_id
     */
    function start_el( &$output, $menu_item, $depth = 0, $args = null, $current_object_id = 0 ) {
        $output .= sprintf( '<li class="%s">', join( ' ', $menu_item->classes ) );
        $output .= sprintf( '<a %s>%s</a>', raptor_output_attr( $this->get_link_attributes( $menu_item ) ), $menu_item->title );
        $output .= $args->walker->has_children ? sprintf( '<button aria-label="%s menu"></button>', $menu_item->title ) : '';
    }
}
