<?php 

/**
 * Disable Gutenberg for pages.
 * 
 * @param bool $use_block_editor
 * @param string $post_type
 * @return bool
 */
function raptor_block_editor_for_post_type( $use_block_editor, $post_type ) {
    if ( $post_type == 'page' ) {
        return false;
    }

    return $use_block_editor;
}
add_filter( 'use_block_editor_for_post_type', 'raptor_block_editor_for_post_type', 10, 2 );


/**
 * Allow Block Types
 */
function raptor_allowed_block_types_all() {
    $blocks = [
        'core/paragraph',
        'core/heading',
        'core/list',
        'core/list-item',
        'core/image',
        'core/gallery',
        'core/columns',
        'core/column',
        'core/shortcode'
    ];

    if ( function_exists( 'rank_math' ) ) {
        $blocks[] = 'rank-math/toc-block';
    }

    return $blocks;
}
add_filter( 'allowed_block_types_all', 'raptor_allowed_block_types_all' );
