<?php
namespace Raptor\Forms;

use Raptor\Forms\Form;

add_action( 'graphql_register_types', function() {
    $field_types = [
        'checkbox' => 'CheckboxField'
    ];

    register_graphql_interface_type( 'RaptorFormFields', [
        'description' => 'Fields to a form',
        'fields' => [
            'type' => [
                'type' => 'String', 
                'description' => 'Field type',
                'resolve' => function( array $field ) {
                    return 'text';
                }
            ],
            'label' => [
                'type' => 'String',
                'description' => 'Field label'
            ],
            'name' => [
                'type' => 'String', 
                'description' => 'Field name'
            ],
            'required' => [
                'type' => 'Bool', 
                'description' => 'Field required'
            ],
        ],
        'resolveType' => function( $thing ) {
            return 'RaptorFormFields';
        }
    ]);


    register_graphql_interface_type(
        'CheckboxField',
        [
            'description' => 'Checkbox field',
            'interfaces' => [ 'RaptorFormFields' ],
            'fields' => [
                'multiple' => [
                    'type' => 'Boolean', 
                    'description' => 'test',
                    'resolve' => function( array $field ) {
                        return $field['multiple'];
                    }
                ]
            ]
        ]
    );

    register_graphql_object_type( 'RaptorForm', [
        'description' => 'The block.',
        'fields' => [
            'title' => [
                'type' => 'String', 
                'description' => 'Form title',
                'resolve' => function( Form $form ) {
                    return $form->title;
                }
            ],
            'name' => [
                'type' => 'String', 
                'description' => 'Form name',
                'resolve' => function( Form $form ) {
                    return $form->name;
                }
            ],
            'id' => [
                'type' => 'Int', 
                'description' => 'Form ID',
                'resolve' => function( Form $form ) {
                    return $form->id;
                }
            ],
            'fields' => [
                'type' => [ 'list_of' => 'RaptorFormFields' ], 
                'description' => 'Form fields',
                'resolve' => function( Form $form ) {
                    return $form->fields;
                }
            ]
        ]
    ]);


    register_graphql_field( 'RootQuery', 'raptorForms', [
        'type' => [ 'list_of' => 'RaptorForm' ],
        'description' => 'Example field added to the RootQuery Type',
        'resolve' => function( $root, $args, $context, $info ) {
            $php_registered_forms = raptor()->forms->forms;

            if ( !empty( $php_registered_forms ) ) {
                $forms = $php_registered_forms;
            }

            $db_registered_forms = get_posts([
                'post_type' => 'raptor_form',
                'posts_per_page' => 1000,
                'fields' => 'ids'
            ]);

            if ( !empty( $db_registered_forms ) ) {
                $forms = array_merge(
                    $forms,
                    array_map( function( int $id ) {
                        return new Form( $id );
                    }, $db_registered_forms )
                );
            }

            return $forms;
        }
    ]);
});
