<?php
namespace Raptor\ACF;

class Icon_Picker {

    /** Settings */
    var $settings;

    function __construct() {

        $this->settings = [
            'version'	=> '0.1',
            'url'      => plugin_dir_url( RAPTOR_PLUGIN_FILE ) . '/includes/acf/field-icon-picker/',
            'path'     => plugin_dir_path( RAPTOR_PLUGIN_FILE ) . '/includes/acf/field-icon-picker/'
        ];

        add_action( 'acf/init_internal_post_types', [ $this, 'include_field' ] );
        add_action( 'wpgraphql/acf/registry_init', [ $this, 'register_graphql_field' ], 10, 4 );
        add_filter( 'wpgraphql/acf/field_value', [ $this, 'graphql_acf_field_value' ], 10, 4 );
        add_filter( 'raptor_acf_icon_picker_field_icons', [ $this, 'get_icon_url' ], 999 );
        add_shortcode( 'icon', [ $this, 'shortcode' ] );
    }

    function include_field( $version = false ) {
        include_once( 'fields/class-field-icon-picker.php' );
    }


    function register_graphql_field() {
        register_graphql_acf_field_type( 'icon_picker' );
    }


    function graphql_acf_field_value( $value, $acf_field ) {
        if ( $acf_field['type'] === 'icon_picker' && $value ) {
            return get_raptor_icon( $value, true );
        }

        return $value;
    }


    function get_icon_url( $icons ) {
        $theme_uri = get_template_directory_uri();

        return array_map( function( $icon ) {
            if ( !isset( $icon['url'] ) ) {
                $icon_filename = $icon['name'] . '.svg';

                $icon['url'] = get_template_directory_uri() . '/assets/icon-set/' . $icon_filename;
            }

            return $icon;
        }, $icons );
    }


    function shortcode( $atts ) {
        $icon_name = $atts['name'];

        $icon_filename = $icon_name . '.svg';
        $icon_url = get_template_directory_uri() . '/assets/icon-set/' . $icon_filename;
        $maybe_value = file_get_contents( $icon_url );

        if ( $maybe_value ) {
            return $maybe_value;
        }

        return '';
    }
}

new Icon_Picker();
