/*global raptor */

export default function CookieNotice() {
  const cookieName = 'raptor_accept_cookie'

  /** Don't load notice for Flexi Block Preview endpoint */
  if (window.location.pathname?.match(/^\/_raptor/)) {
    return
  }

  if (document.cookie.indexOf(cookieName) == -1) {
    const el = document.createElement('div')
    el.classList.add('raptor-cookie-notice')

    el.innerHTML = `
        <div>${raptor.cookie.message}</div>
        <button id="raptor-cookie-accept" class="button">Accept<span class="screen-reader-text"> cookies on this site.</span></button>
        <a href="${raptor.cookie.policyLink}" class="button button--text">Learn More<span class="screen-reader-text"> about cookies on this site.</span></a>
    `

    document.body.appendChild(el)

    setTimeout(function() {
      el.classList.add('is-visible')
    }, 1000)

    // Listen for notice acceptance
    document.getElementById('raptor-cookie-accept').addEventListener('click', e => {
      e.preventDefault()

      const expiry = new Date()
      expiry.setDate(expiry.getDate() + 30)
      document.cookie = `${cookieName}=${true}; expires=${expiry}; path=/`

      el.classList.remove('is-visible')

      setTimeout(() => {
        document.body.removeChild(el)
      }, 1000)
    })
  }
}
