<?php
/**
 * Hero Standard
 * 
 * @var int $attachment_id
 * @var string $title
 * @var string $content
 */
?>
<div class="hero hero--standard<?php echo $attachment_id ? ' with-post-thumbnail' : ''; ?>">
    <?php if ( $attachment_id ) : ?>
    <div class="hero__feature-image">
        <?php
        raptor_image(
            $attachment_id, 
            'full',
            [
                'loading' => false,
                'fetchpriority' => 'high'
            ]
        );
        ?>
    </div>
    <?php endif; ?>
    <div class="hero__content">
        <div class="container">
            <?php
            if ( !empty( $title ) ) {
                printf( '<h1>%s</h1>', $title );
            }

            echo $content;
            ?>
        </div>
    </div>
</div>
