<?php
/**
 * Enqueue scripts & styles
 */

/**  
 *  Add Raptor styles and scripts for frontend usage
 *  Remove core WP styles and scripts that aren't needed
 *  Statements monitor usage of jQuery for Woocommerce as standard
 */
function raptor_scripts() {
    if ( !is_user_logged_in() ) {
        wp_deregister_script( 'jquery' );
    } else {
        wp_enqueue_script( 'jquery' );
    }

    wp_deregister_script( 'wp-embed' );

    // Used for development mode only
    wp_register_script( 'raptor-runtime', 'http://localhost:3000/assets/js/runtime.js', [], null );

    if ( wp_get_environment_type() == 'development' ) {
        wp_enqueue_script( 'raptor-runtime' );
    }
    
    // Scripts
    wp_register_script( 'raptor-main', get_template_directory_uri() . '/assets/js/frontend.js', [], raptor()->version, [ 'in_footer' => true ] );
    wp_enqueue_script( 'raptor-main' );
    wp_localize_script( 'raptor-main', 'raptor', raptor_js_object() );

    if ( defined( 'GOOGLE_API_KEY' ) ) {
        wp_register_script( 'raptor-google-maps', 'https://maps.googleapis.com/maps/api/js?key=' . GOOGLE_API_KEY . '&callback=initRaptorGoogleMaps', [], raptor()->version, [ 'in_footer' => true ] );
    }

    wp_register_script( 'raptor-glide', get_template_directory_uri() . '/assets/js/glide.js', [], raptor()->version, [ 'in_footer' => true ] );

    // Styles
    wp_enqueue_style( 'raptor-style', get_template_directory_uri() . '/assets/css/frontend.css', [], raptor()->version );

    // Remove WP Glutenburg styling as not supported by the theme yet
    wp_dequeue_style( 'wp-block-library' );
}
add_action( 'wp_enqueue_scripts', 'raptor_scripts', 999 );
