<?php 
/**
 * 404 page
 */
get_header();
?>


<main class="site-main" id="main-content">
    <div class="error404-content content">
        <?php
        /**
         * The hard coded content can be replaced via the CMS if a page with the title "404" is created.
         */
        $query = new WP_Query([
            'post_type' => 'page',
            'post_title' => '404'
        ]);

        if ( $query->have_posts() ) {
            echo apply_filters( 'the_content', $query->posts[0]->post_content );
        } else {
            ?>
        <h1>404 - page not found</h1>
        <p>The page you requested could not be found.</p>
        <div>
            <a href="<?php echo home_url(); ?>" class="button">Back to home page</a>
        </div>
        <?php } ?>
    </div>
</main>
    

<?php get_footer(); ?>
