#!/usr/bin/env bash

. .raptor/global.sh || exit 1


if [  $# -le 0 ]
then
	echo $cyan"Create a new block or template"$white
    echo "create [block|template|part] <slug> <name>"
    exit 1
fi

WP_THEME="wp-content/themes/raptor-frontend"
STYLE_HEADING="Template"

FILE_TYPE=$1
SLUG=$2
NAME=$3


append_empty_lines() {
    echo "" >> $1
    echo "" >> $1
}


if [[ -e "$WP_THEME"/"$FILE_TYPE"s/$SLUG.php ]]
then
    echo $red"This $FILE_TYPE already exists."$white
    exit 1
fi

if [ $FILE_TYPE == "part" ]
then
    mkdir -p "$WP_THEME"/src/scss/parts
fi

if [[ ! -e "$WP_THEME"/"$FILE_TYPE"s ]]
then
    mkdir "$WP_THEME"/"$FILE_TYPE"s
fi

if [[ ! -e "$WP_THEME"/src/scss/"$FILE_TYPE"s ]]
then
    mkdir "$WP_THEME"/src/scss/"$FILE_TYPE"s
fi

cp .raptor/sample-files/"$FILE_TYPE".php "$WP_THEME"/"$FILE_TYPE"s/$SLUG.php
sed -i '' -e 's/__NAME__/'"$NAME"'/g' "$WP_THEME"/"$FILE_TYPE"s/$SLUG.php


cp .raptor/sample-files/"$FILE_TYPE".scss "$WP_THEME"/src/scss/"$FILE_TYPE"s/_$SLUG.scss
sed -i '' -e 's/__SLUG__/'"$SLUG"'/g' "$WP_THEME"/src/scss/"$FILE_TYPE"s/_$SLUG.scss


if [ $FILE_TYPE == "block" ]
then
    STYLE_HEADING="Block"

    append_empty_lines $WP_THEME/acf/blocks/blocks.php
    cp .raptor/sample-files/acf-block-scaffold.php acf-block-scaffold.php
    sed -i '' -e 's/__NAME__/'"$NAME"'/g' acf-block-scaffold.php
    sed -i '' -e 's/__SLUG__/'"$SLUG"'/g' acf-block-scaffold.php
    tail -n +2 acf-block-scaffold.php >> $WP_THEME/acf/blocks/blocks.php
    rm acf-block-scaffold.php
fi

if [ $FILE_TYPE == "part" ]
then
    STYLE_HEADING="Part"
fi


sed -i '' -e '/\/\/  '$STYLE_HEADING'/a\
@use "'$FILE_TYPE's/'$SLUG'";'  "$WP_THEME"/src/scss/main.scss