#!/usr/bin/env bash

. .raptor/global.sh || exit 1

echo $cyan'Preparing to fetch site...'$white

TARGET="staging"

REMOTE_LOCATION=$(get_host $TARGET)
SQL_EXPORT_FILE="fetch-env.sql"


ssh $(get_host $TARGET "root") "
    cd $( echo "$STAGING_PATH" );
    wp db export $( echo "$SQL_EXPORT_FILE" );
"

echo "Downloading all files..."
rsync -avz "$REMOTE_LOCATION"/ ./

echo "Setting wp-config.php constants"
wp config set DB_NAME "wordpress"
wp config set DB_USER "wordpress"
wp config set DB_PASSWORD "wordpress"
wp config set DB_HOST "database"
wp config set WP_ENVIRONMENT_TYPE "development"

# Start lando
lando start

# Create DB and import
lando db-import --database=wordpress $SQL_EXPORT_FILE

# Clean up, remove exported SQL file.
rm $SQL_EXPORT_FILE

ssh $(get_host $TARGET "root") "
    cd $( echo "$STAGING_PATH" );
    rm $( echo "$SQL_EXPORT_FILE" );
"

# Use sync-db to get database setuo correctly.
.raptor/commands/sync-db.sh staging dev

