<?php

use Raptor\ACF\Utils as Utils;
use Raptor\ACF\Group;
use Raptor\ACF\Flexi_Builder;
use Raptor\ACF\Field_Types;

/**
 * Single Post - Related Posts
 */
new Group(
    'single_post_related_posts',
    [
        'title'     => 'Related Posts',
        'fields'    => [
            Field_Types\post_object_field(
                'Related Posts',
                [
                    'post_type' => 'post',
                    'instructions' => 'Choose which posts to suggest.'
                ]
            )
        ],
        'position' => 'side',
        'location'  => [
            [
                [
                    'param'     => 'post_type',
                    'operator'  => '==',
                    'value'     => 'post'
                ]
            ]
        ]
    ]
);
