<?php

namespace Raptor\Headless;

use WPGraphQL\Model\Post;

class GraphQL_Register_Fields {
    /**
     * Set hooks.
     */
    function __construct( array $callbacks ) {
        foreach ( $callbacks as $callback ) {
            add_action( 'graphql_register_types', [ $this, $callback ] );
        }
    }

    function site_logo_icon() {
        register_graphql_field(
            'RootQuery',
            'siteLogo',
            [
                'type' => 'MediaItem',
                'description' => 'The logo set in the customizer',
                'resolve' => function() {
                    $logo_id = get_theme_mod( 'custom_logo' );

                    if ( !isset( $logo_id ) || !absint( $logo_id ) ) {
                        return null;
                    }

                    $media_object = get_post( $logo_id );
                    return new \WPGraphQL\Model\Post( $media_object );

                }
            ]
        );

        register_graphql_field(
            'RootQuery',
            'siteIcon',
            [
                'type' => 'MediaItem',
                'description' => 'The icon set in the customizer',
                'resolve' => function() {
                    $logo_id = get_option( 'site_icon' );

                    if ( !$logo_id || !absint( $logo_id ) ) {
                        return null;
                    }

                    $media_object = get_post( $logo_id );

                    if ( !$media_object ) {
                        return null;
                    }

                    return new \WPGraphQL\Model\Post( $media_object );
                }
            ]
        );
    }


    function custom_css() {
        register_graphql_field(
            'RootQuery',
            'customCSS',
            [
                'type' => 'String',
                'description' => 'The custom CSS',
                'resolve' => function() {
                    return wp_get_custom_css();
                }
            ]
        );
    }


    function media_item() {
        register_graphql_field(
            'mediaItem',
            'inlineSvg',
            [
                'type' => 'String',
                'description' => 'The svg code',
                'resolve' => function( Post $post ) {
                    $_post = get_post( $post->ID );
                    $mime_type = get_post_mime_type( $_post );
    
                    if ( $mime_type == 'image/svg+xml' ) {
                        $image_url = wp_get_attachment_url( $post->ID );
                        $image_url = str_replace( get_site_url(), ABSPATH, $image_url );
    
                        $svg = file_get_contents( $image_url );
                            
                        return $svg;
                    }
    
                    return null;
                }
            ]
        );

        register_graphql_field(
            'mediaItem',
            'priority',
            [
                'type' => 'Int',
                'description' => 'The menu order',
                'resolve' => function( Post $post ) {
                    $_post = get_post( $post->ID );
                    return $_post->menu_order;
                }
            ]
        );
    }
}

new GraphQL_Register_Fields([
    'site_logo_icon',
    'custom_css',
    'media_item'
]);
