<?php 
namespace Raptor\Forms\Field_Type;

use Raptor\Forms\Field_Type;
use Raptor\Forms\Form;

class Select extends Field_Type {
    /**
     * It'll be good to set field specific defaults here.
     */
    function __construct( array $settings, Form $form ) {
        parent::__construct( $form );

        $default_settings = array_merge(
            $this->universal_settings,
            [
                'show_option_none' => '',
                'multiple' => false,
                'options' => []
            ]
        );

        $this->settings = wp_parse_args( $settings, $default_settings );
    }

    function render_field() {
        if ( !empty( $this->settings['label'] ) ) {
            printf( '<label for="%s">%s</label>', $this->html_id(), $this->label() );
        }

        // Field attributes
        $attributes = $this->setup_attributes();

        if ( $this->settings['multiple'] ) {
            $attributes['multiple'] = '';
            $attributes['name'] .= '[]';
        }

        printf( '<select class="form-select" %s>', $this->output_attributes( $attributes ) );

        if ( $this->settings['show_option_none'] ) {
            printf( '<option value="">%s</option>', $this->settings['show_option_none'] );
        }

        $options = apply_filters( 'raptor_forms_select_field_options', $this->settings['options'], $this );

        foreach ( $options as $option ) {
            printf( '<option value="%s">%s</option>', isset( $option['value'] ) ? $option['value'] : $option['label'], $option['label'] );
        }

        echo '</select>';
    }
}
