<?php
namespace Raptor;
use WP_CLI;

class CLI {
    /**
     * Activate a license key.
     * 
     * <key>
     * : The license key
     */
    static function activate( $args ) {
        $updater = new Updater;
        $res = $updater->activate_license( $args[0] );

        if ( $res['success'] ) {
            WP_CLI::success( 'Raptor Toolkit license activated.' );
            
        } else {
            WP_CLI::error( $res['message'] );
        }
    }

    /**
     * Check for latest release of Raptor Toolkit.
     */
    static function update_check() {
        $updater = new Updater;
        $res = $updater->update_check();

        var_dump( $res );

        WP_CLI::success( 'Update check complete.' );
    }
}

function cli_init() {
    WP_CLI::add_command( 'raptor activate', [ 'Raptor\CLI', 'activate' ] );    
    WP_CLI::add_command( 'raptor update-check', [ 'Raptor\CLI', 'update_check' ] );
}
add_action( 'cli_init', 'Raptor\cli_init' );
