<?php
namespace Raptor;

use Raptor\API;
/**
 * Monitor the sending of emails using `wp_mail()`.
 * 
 * Should a failed send occur, an API request is sent to Raptor API `/v1/mail-monitor` which will
 * trigger a notification by email.
 */
class Mail_Monitor {
    /**
     * Send request to Raptor API.
     */
    static function notify( array $data ) {
        // Data sent to Raptor
        $global_data = [
            'wp_url' => home_url(),
            'wp_name' => get_bloginfo( 'name' ),
        ];

        $data = array_merge( $global_data, $data );

        $res = API::post( 'v1/mail-monitor', $data );
    }
}

new Mail_Monitor;
