<!DOCTYPE html>

<html <?php language_attributes(); ?>>
    <head>
        <meta charset="utf-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">

        <?php wp_head(); ?>
 
        <script>document.documentElement.classList.add('js');</script>
    </head>
    
    <body <?php raptor_body_class(); ?>>
        <?php wp_body_open(); ?>
        <a class="skip-link button" href="#main-content">Skip to content</a>

        <div class="header-wrapper">
            <header class="site-header">
                <div class="container">
                    <?php
                    if ( has_custom_logo() ) {
                        the_custom_logo();
                    }
                    ?>

                    <?php raptor_nav_primary(); ?>
    
                    <button id="mobile-menu-trigger">
                        <svg width="18" height="16" viewBox="0 0 18 16">
                            <title>Open mobile navigation</title>
                            <g fill="#000">
                                <rect width="18" height="1" y="3" />
                                <rect width="18" height="1" y="12" />
                            </g>
                        </svg>
                    </button>
                </div>
            </header>

            <div class="mobile-menu">
                <button id="mobile-menu-close" aria-label="Close menu">
                    <svg width="18" height="15" viewBox="0 0 18 15">
                        <title>Close mobile navigation</title>
                        <g fill="#000">
                            <rect width="18" height="1" y="7" transform="rotate(45,9,8)" />
                            <rect width="18" height="1" y="7" transform="rotate(-45,9,8)" />
                        </g>
                    </svg>
                </button>
                <?php raptor_nav_primary_mobile(); ?>
            </div>
            <div class="mobile-menu-overlay"></div>
        </div>
