<?php

/**
 * Return true if the function should not run.
 * 
 * @param bool $exit Defaults to true
 */
add_filter( 'raptor_preload_post_thumbnail_early_exit', function( $exit ) {

    if ( is_singular( [ 'post' ] ) ) {
        return false;
    }

    if ( is_singular( [ 'page' ] ) && get_page_template_slug() == 'templates/flexi-blocks-builder.php' ) {
        return false;
    }

    return true;
});

/**
 * Filter the size of the image that should be preloaded.
 * 
 * @param string $size `large` by default
 */
add_filter( 'raptor_preload_post_thumbnail_size', function( $size ) {

    if ( is_singular( 'post' ) ) {
        $size = 'large';
    }

    if ( is_singular( [ 'page' ] ) && get_page_template_slug() == 'templates/flexi-blocks-builder.php' ) {
        $size = 'full';
    }

    return $size;
});

/**
 * Filter the size of the image that should be preloaded.
 * 
 * @param integer $id Post thumbnail ID
 */
add_filter( 'raptor_preload_post_thumbnail_id', function( $id ) {

    return $id;
});
